﻿------------------------------------------------------------------------------------------------------
-- Totemus Options Dialog
--
-- Maintainer: Poolpy & Yorgl
--
-- Based on Ideas by:
--   Venantes by Zirah (http://www.wowinterface.com/downloads/info6155-Venantes.html)
--   Necrosis LdC by Lomig and Nyx (http://necrosis.larmes-cenarius.net)
--   Original Necrosis Idea : Infernal (http://www.revolvus.com/games/interface/necrosis/)
------------------------------------------------------------------------------------------------------

TotemusOptions = {};

local L = AceLibrary('AceLocale-2.2'):new('Totemus');


TotemusOptions.tabFrameNames = { 'Sphere', 'Buttons', 'Messages', 'Timers', 'Inventory', 'Debug' };


-- Initialize the options
function TotemusOptions:Initialize()
    UIPanelWindows["TotemusOptionsFrame"] = { area = "LEFT", pushable = 5, whileDead = 1  };

    TotemusOptionsFrameTitleText:SetText(GetAddOnMetadata('Totemus', 'Title')..' '..GetAddOnMetadata('Totemus', 'Version'));
    
    -- make dragable
    TotemusOptionsFrame:RegisterForDrag('LeftButton');
    
    -- tooltips
    self:InitializeLabel(TotemusOptionsLabel_Tooltips);
    self:InitializeCheckbox(TotemusOptionsCheckButton_Tooltips, Totemus.db.char.buttonTooltips);
    self:InitializeLabel(TotemusOptionsLabel_DefaultTooltips);
    self:InitializeCheckbox(TotemusOptionsCheckButton_DefaultTooltips, Totemus.db.char.buttonDefaultTooltips);
    
    -- menu behaviuor
    self:InitializeLabel(TotemusOptionsLabel_MenuKeepOpen);
    self:InitializeCheckbox(TotemusOptionsCheckButton_MenuKeepOpen, Totemus.db.char.menuKeepOpen);
    
    -- message options
    self:InitializeLabel(TotemusOptionsLabel_OnScreen);
    self:InitializeCheckbox(TotemusOptionsCheckButton_OnScreen, Totemus.db.char.messagesOnScreen);
    self:InitializeLabel(TotemusOptionsLabel_DebugTexture);
    self:InitializeCheckbox(TotemusOptionsCheckButton_DebugTexture, Totemus.db.char.messagesMissingTexture);
    self:InitializeLabel(TotemusOptionsLabel_Raid);
    self:InitializeCheckbox(TotemusOptionsCheckButton_Raid, Totemus.db.char.messagesRaidMode);
    self:InitializeLabel(TotemusOptionsLabel_MsgRandom);
    self:InitializeCheckbox(TotemusOptionsCheckButton_MsgRandom, Totemus.db.char.messagesRandom);
    self:InitializeLabel(TotemusOptionsLabel_MsgRandomAncestralSpirit);
    self:InitializeCheckbox(TotemusOptionsCheckButton_MsgRandomAncestralSpirit, Totemus.db.char.messagesRandomAncestralSpirit);
    self:InitializeLabel(TotemusOptionsLabel_MsgRandomMount);
    self:InitializeCheckbox(TotemusOptionsCheckButton_MsgRandomMount, Totemus.db.char.messagesRandomMount);
    self:InitializeSlider(TotemusOptionsSlider_MsgRandomLanguage, Totemus.db.char.messagesLanguage, L['MESSAGES_LANGUAGE']);
    TotemusOptionsSlider_MsgRandomLanguage:SetMinMaxValues(1, Totemus:GetSpeechLanguageCount());
    
    -- timers options
    self:InitializeLabel(TotemusOptionsLabel_Show);
    self:InitializeCheckbox(TotemusOptionsCheckButton_Show, Totemus.db.char.timersShow);
    self:InitializeLabel(TotemusOptionsLabel_Lock);
    self:InitializeCheckbox(TotemusOptionsCheckButton_Lock, Totemus.db.char.timersLock);
    self:InitializeLabel(TotemusOptionsLabel_Warn);
    self:InitializeCheckbox(TotemusOptionsCheckButton_Warn, Totemus.db.char.timersWarn);
    self:InitializeLabel(TotemusOptionsLabel_Notify);
    self:InitializeCheckbox(TotemusOptionsCheckButton_Notify, Totemus.db.char.timersNotify);
    self:InitializeLabel(TotemusOptionsLabel_Time);
    self:InitializeCheckbox(TotemusOptionsCheckButton_Time, Totemus.db.char.timersTime);
    self:InitializeSlider(TotemusOptionsSlider_timersArrange, Totemus.db.char.timersArrange, L['TIMERS_ARRANGE']);
    TotemusOptionsSlider_timersArrange:SetMinMaxValues(1, 3);
    self:InitializeSlider(TotemusOptionsSlider_timersAlign, Totemus.db.char.timersAlign, L['TIMERS_ALIGN']);
    TotemusOptionsSlider_timersAlign:SetMinMaxValues(1, 2);
    self:InitializeSlider(TotemusOptionsSlider_timersStyle, Totemus.db.char.timersStyle, L['TIMERS_STYLE']);
    TotemusOptionsSlider_timersStyle:SetMinMaxValues(1, 4);

    -- Sphere Options
    self:InitializeLabel(TotemusOptionsLabel_LockSphere);
    self:InitializeLabel(TotemusOptionsLabel_LockButtons);
    self:InitializeCheckbox(TotemusOptionsCheckButton_SphereLocking, Totemus.db.char.sphereLocking);
    self:InitializeCheckbox(TotemusOptionsCheckButton_ButtonLocking, Totemus.db.char.buttonLocking);
    self:InitializeSlider(TotemusOptionsSlider_SphereRotation, Totemus.db.char.sphereRotation, L['SPHERE_ROTATION']);
    self:InitializeSlider(TotemusOptionsSlider_SphereScale, Totemus.db.char.sphereScale, L['SPHERE_SCALE']);
    local sphereCircleStatusCount, sphereTextStatusCount = Totemus:SphereGetStatusCount();
    self:InitializeSlider(TotemusOptionsSlider_SphereCircle, Totemus.db.char.sphereStatusCircle, L['SPHERE_CIRCLE']);
    TotemusOptionsSlider_SphereCircle:SetMinMaxValues(0, sphereCircleStatusCount);
    self:InitializeSlider(TotemusOptionsSlider_SphereText, Totemus.db.char.sphereStatusText, L['SPHERE_TEXT']);
    TotemusOptionsSlider_SphereText:SetMinMaxValues(0, sphereTextStatusCount);
    self:InitializeSlider(TotemusOptionsSlider_SphereActionLeft, Totemus.db.char.sphereActionLeft, L['TOOLTIP_LEFTCLICK']);
    TotemusOptionsSlider_SphereActionLeft:SetMinMaxValues(0, Totemus:ButtonGetActionCount());
    self:InitializeSlider(TotemusOptionsSlider_SphereActionRight, Totemus.db.char.sphereActionRight, L['TOOLTIP_RIGHTCLICK']);
    TotemusOptionsSlider_SphereActionRight:SetMinMaxValues(0, Totemus:ButtonGetActionCount());
  
    -- button options
    self:InitializeLabel(TotemusOptionsLabel_ShowButtons);
    self:InitializeLabel(TotemusOptionsLabel_last);
    self:InitializeCheckbox(TotemusOptionsCheckButton_locklast, Totemus.db.char.buttonlocklast);
    self:InitializeLabel(TotemusOptionsLabel_Drink);
    self:InitializeCheckbox(TotemusOptionsCheckButton_Drink, Totemus.db.char.buttonDrinkVisible);
    self:InitializeLabel(TotemusOptionsLabel_Potion);
    self:InitializeCheckbox(TotemusOptionsCheckButton_Potion, Totemus.db.char.buttonPotionVisible);
    self:InitializeLabel(TotemusOptionsLabel_Mount);
    self:InitializeCheckbox(TotemusOptionsCheckButton_Mount, Totemus.db.char.buttonMountVisible);
    self:InitializeLabel(TotemusOptionsLabel_BuffMenu);
    self:InitializeCheckbox(TotemusOptionsCheckButton_BuffMenu, Totemus.db.char.buttonBuffMenuVisible);
    self:InitializeLabel(TotemusOptionsLabel_AirMenu);
    self:InitializeCheckbox(TotemusOptionsCheckButton_AirMenu, Totemus.db.char.buttonAirMenuVisible);
    self:InitializeLabel(TotemusOptionsLabel_EauMenu);
    self:InitializeCheckbox(TotemusOptionsCheckButton_EauMenu, Totemus.db.char.buttonEauMenuVisible);
    self:InitializeLabel(TotemusOptionsLabel_FeuMenu);
    self:InitializeCheckbox(TotemusOptionsCheckButton_FeuMenu, Totemus.db.char.buttonFeuMenuVisible);
    self:InitializeLabel(TotemusOptionsLabel_TerreMenu);
    self:InitializeCheckbox(TotemusOptionsCheckButton_TerreMenu, Totemus.db.char.buttonTerreMenuVisible);
    -- action button options
    self:InitializeLabel(TotemusOptionsLabel_ActionOne);
    self:InitializeCheckbox(TotemusOptionsCheckButton_ActionOne, Totemus.db.char.buttonActionOneVisible);
    self:InitializeSlider(TotemusOptionsSlider_ActionOneLeft, Totemus.db.char.buttonActionOneLeft, L['TOOLTIP_LEFTCLICK']);
    TotemusOptionsSlider_ActionOneLeft:SetMinMaxValues(0, Totemus:ButtonGetActionCount());
    self:InitializeSlider(TotemusOptionsSlider_ActionOneRight, Totemus.db.char.buttonActionOneRight, L['TOOLTIP_RIGHTCLICK']);
    TotemusOptionsSlider_ActionOneRight:SetMinMaxValues(0, Totemus:ButtonGetActionCount());
    self:InitializeLabel(TotemusOptionsLabel_ActionTwo);
    self:InitializeCheckbox(TotemusOptionsCheckButton_ActionTwo, Totemus.db.char.buttonActionTwoVisible);
    self:InitializeSlider(TotemusOptionsSlider_ActionTwoLeft, Totemus.db.char.buttonActionTwoLeft, L['TOOLTIP_LEFTCLICK']);
    TotemusOptionsSlider_ActionTwoLeft:SetMinMaxValues(0, Totemus:ButtonGetActionCount());
    self:InitializeSlider(TotemusOptionsSlider_ActionTwoRight, Totemus.db.char.buttonActionTwoRight, L['TOOLTIP_RIGHTCLICK']);
    TotemusOptionsSlider_ActionTwoRight:SetMinMaxValues(0, Totemus:ButtonGetActionCount());

    -- debug 
    self:InitializeLabel(TotemusOptionsDebugItemTitle);
    self:InitializeLabel(TotemusOptionsDebugTexture);
    self:ShowTextureMessages();
  
    self:TabButtonClick('Sphere', 'TAB_SPHERE');
end

function TotemusOptions:UpdateData() 
    self:ShowTextureMessages();
end

function TotemusOptions:ShowTextureMessages()
    local textureStr = '';
    if Totemus.missingTextures ~= nil and type(Totemus.missingTextures) == 'table' then
        for texture, _ in pairs(Totemus.missingTextures) do
            textureStr = texture..', '..textureStr;
        end
        TotemusOptionsDebugTextureMsgs:SetText(textureStr);
    end
end

function TotemusOptions:InitializeLabel(element) 
    if element ~= nil then
        local stringIdent = element:GetText();
        if L[stringIdent]  ~= nil then
            element:SetText(L[stringIdent])
        end
    end
end

function TotemusOptions:InitializeCheckbox(element, value) 
    if element ~= nil then
        element:SetChecked(value);
    end
end

function TotemusOptions:InitializeSlider(element, value, topText, leftText, rightText) 
    if element ~= nil then
        element:SetValue(value);
        local elementName = element:GetName();
        if topText ~= nil then
            getglobal(elementName..'Text'):SetText(topText);
        end
        if leftText ~= nil then
            getglobal(elementName..'Low'):SetText(leftText);
        else
            getglobal(elementName..'Low'):SetText('');
        end
        if leftText ~= nil then
            getglobal(elementName..'High'):SetText(rightText);
        else
            getglobal(elementName..'High'):SetText('');
        end        
    end
end

function TotemusOptions:TabButtonClick(tabId, tabTitle)
    local tabFrame, tabButton;
	for i=1, table.getn(self.tabFrameNames), 1 do
		tabFrame = getglobal('TotemusOptionsFrame'..self.tabFrameNames[i]);
		tabButton = getglobal('TotemusOptionsTab'..self.tabFrameNames[i]);
        if tabId == self.tabFrameNames[i] then
            if tabButton ~= nil then
                tabButton:SetChecked(true);
            end
            if tabFrame ~= nil then
                ShowUIPanel(tabFrame);
            end
        else
            if tabButton ~= nil then
                tabButton:SetChecked(false);
            end
            if tabFrame ~= nil then
                HideUIPanel(tabFrame);
            end
        end
        if L[tabTitle] ~= nil then
            TotemusOptionsFrameSubTitleText:SetText(L[tabTitle]);
        end
	end
end

function TotemusOptions:ShowTooltip(element, elementId, anchor)  
    GameTooltip:SetOwner(element, anchor);
 
    -- show value
    if elementId == 'VALUE' then    
        GameTooltip:AddLine(element:GetValue());
    elseif elementId == 'ACTION_VALUE' then    
        local actionIdx = element:GetValue();
        local actionType, actionName, _, _, _, _, actionSlotName = Totemus:ButtonGetActionInfo(actionIdx);
        if actionType == 'slot' and actionSlotName then
            local actionPrefix = actionSlotName;
            if L['SLOT_'..actionSlotName] ~= nil then
                actionPrefix = L['SLOT_'..actionSlotName];
            end
            if actionName ~= nil then
                GameTooltip:AddLine(actionPrefix..': '..actionName);
            else 
                GameTooltip:AddLine(actionPrefix..': '..L['NONE']);
            end            
        else
            if actionName ~= nil then
                GameTooltip:AddLine(actionName);
            else 
                GameTooltip:AddLine(L['NONE']);
            end
        end
   elseif elementId == 'ARRANGE' then   
        local arrangeName = Totemus:TimersGetArrangeName(element:GetValue()); 
        if arrangeName ~= nil then
            GameTooltip:AddLine(arrangeName);
        else 
            GameTooltip:AddLine('Horizontal');
        end
   elseif elementId == 'ALIGN' then   
        local alignName = Totemus:TimersGetAlignName(element:GetValue()); 
        if alignName ~= nil then
            GameTooltip:AddLine(alignName);
        else 
            GameTooltip:AddLine('Left/Top');
        end
   elseif elementId == 'STYLE' then   
        local styleName = Totemus:TimersGetStyleName(element:GetValue()); 
        if styleName ~= nil then
            GameTooltip:AddLine(styleName);
        else 
            GameTooltip:AddLine('Sticky');
        end
    elseif elementId == 'SPHERE_CIRCLE' then   
        local circleStatus = Totemus:SphereGetStatusInfo(element:GetValue(), nil); 
        if circleStatus ~= nil then
            if L['STATUS_'..circleStatus] ~= nil then
                GameTooltip:AddLine(L['STATUS_'..circleStatus]);
            else
                GameTooltip:AddLine(circleStatus);
            end
        else 
            GameTooltip:AddLine(L['NONE']);
        end
    elseif elementId == 'SPHERE_TEXT' then   
        local _, textStatus = Totemus:SphereGetStatusInfo(nil, element:GetValue()); 
        if textStatus ~= nil then
            if L['STATUS_'..textStatus] ~= nil then
                GameTooltip:AddLine(L['STATUS_'..textStatus]);
            else
                GameTooltip:AddLine(textStatus);
            end
        else 
            GameTooltip:AddLine(L['NONE']);
        end        
    -- get directly from localisation
    elseif elementId == 'MSG_LANGUAGE' then
        GameTooltip:AddLine(Totemus:GetSpeechLanguage(element:GetValue()));
    elseif L[elementId] ~= nil then    
        GameTooltip:AddLine(L[elementId]);
    end
  
	-- and done, show it!
	GameTooltip:Show();
end

function TotemusOptions:HideTooltip()
    GameTooltip:Hide();
end

function TotemusOptions:Invalidate(status, positions, dragable)
    if dragable then
        Totemus:ButtonSetDragable();
        Totemus:ButtonSetPositions();
    elseif positions then
        Totemus:ButtonSetPositions();
        Totemus:ButtonUpdateMenus();
    end
    if status then
        Totemus:UpdateActions();
    end
    Totemus:UpdateStatus();
end

function TotemusOptions:SetOptionSlider(element, optionName) 
    local optionValue = element:GetValue();
    Totemus.db.char[optionName] = optionValue;
end

function TotemusOptions:SetOptionCheckbox(element, optionName) 
    local checked = element:GetChecked();
    if (checked) then
        Totemus.db.char[optionName] = true;
    else
        Totemus.db.char[optionName] = false;
    end
end

function TotemusOptions:OnDebugItemDrop() 
    if CursorHasItem() then
        if GetCursorInfo ~= nil then
            local cursorType, itemId = GetCursorInfo();
            if itemId ~= nil then
                local itemName, _, _, _, _, _, _, _, _, itemTexture = GetItemInfo(itemId);
                if itemName ~= nil then
                    TotemusOptionsDebugItemIcon:SetTexture(itemTexture);
                    TotemusOptionsDebugItemEdit:SetText(itemName..' - '..itemId);
                    TotemusOptionsDebugTextureMsgs:SetText(itemTexture);
                end
            end
        else
            Totemus:ShowMessage('Sorry, but this works only in WoW >= 2.0.3', 'USER');
        end
    end
end